<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package aaa
 */

?>
<!doctype html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="https://gmpg.org/xfn/11">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Grand+Hotel&family=Dosis:wght@600&family=Source+Sans+Pro:ital,wght@0,400;0,700;1,400;1,700&display=swap" rel="stylesheet"> 
	<?php wp_head(); ?>

<!-- Google tag (gtag.js) -->
    <script async src="https://www.googletagmanager.com/gtag/js?id=G-S48JC39LLF"></script>
    <script>
      window.dataLayer = window.dataLayer || [];
  	  function gtag(){dataLayer.push(arguments);}
      gtag('js', new Date());

      gtag('config', 'G-S48JC39LLF');
    </script>
<!-- FIN Google tag (gtag.js) -->
</head>

<body <?php body_class(); ?>>
<?php wp_body_open(); ?>
<div id="page" class="site">
	<a class="skip-link screen-reader-text" href="#primary"><?php esc_html_e( 'Skip to content', 'aaa' ); ?></a>

	<header id="masthead" class="site-header">

		
		
	    <div class="site-branding">
            <a href="/"><img src="<?php echo get_stylesheet_directory_uri(); ?>/design/logo-pays-de-morlaix-3.svg" alt="Logo du Pays de Morlaix" onerror="this.removeAttribute('onerror'); this.src='<?php echo get_stylesheet_directory_uri(); ?>/design/logo-pays-de-morlaix-3.png'"/></a>
		</div><!-- .site-branding -->

		
		
		<nav id="site-navigation" class="main-navigation">
            <input type="checkbox" class="menu-checkbox" id="menu-checkbox" />
			<label for="menu-checkbox" class="menu-toggle">&equiv; Menu</label>
			
			<?php
			wp_nav_menu(
				array(
					'container' => 'false',
					'theme_location' => 'menu-1',
					'menu_id'        => 'primary-menu',
				)
			);
			?>
		</nav><!-- #site-navigation -->
		
		
		
		<nav class="boutons">

			<a href="https://www.linkedin.com/company/pays-de-morlaix/"><img src="<?php echo get_stylesheet_directory_uri(); ?>/design/picto-linkedin.svg" alt="Linkedin" onerror="this.removeAttribute('onerror'); this.src='<?php echo get_stylesheet_directory_uri(); ?>/design/picto-linkedin.png'"/></a>
			<a href="https://www.facebook.com/paysdemorlaixofficiel"><img src="<?php echo get_stylesheet_directory_uri(); ?>/design/picto-facebook.svg" alt="Facebook" onerror="this.removeAttribute('onerror'); this.src='<?php echo get_stylesheet_directory_uri(); ?>/design/picto-facebook.png'"/></a>
			<a href="/contact"><img src="<?php echo get_stylesheet_directory_uri(); ?>/design/picto-contact.svg" alt="Contact" onerror="this.removeAttribute('onerror'); this.src='<?php echo get_stylesheet_directory_uri(); ?>/design/picto-contact.png'"/></a>
		</nav><!-- .boutons -->


	</header><!-- #masthead -->
	<?php 
	if (!is_single() ) {
	get_template_part( 'template-parts/content', 'slider-pages' );
	}
	?>
