<?php
/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package aaa
 */

?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<header class="entry-header">	
		
		<?php 
		if ( is_singular() ) :
		    aaa_post_thumbnail();
		endif; //fin if pour afficher le post-thumbnail
		$category = get_the_category(); 
		?>
        <span class=surtitre-categorie><?php echo $category[0]->cat_name; ?></span>		
		
		
		<?php		
		if ( is_singular() ) :
		
			the_title( '<h1 class="entry-title">', '</h1>' );
		    ?>
		<span class="date-du-post">Publié le</span>
		<?php
	    the_date();
		else :
			the_title( '<h2 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h2>' );
		
	    endif; // fin du if pour mettre le titre en h1 ou h2


	
	   // ??? if ( 'post' === get_post_type() ) :
		// ??? endif; 
	?>


	
	</header><!-- .entry-header -->


	<div class="entry-content">		

		<?php
		the_content(
			sprintf(
				wp_kses(
					/* translators: %s: Name of current post. Only visible to screen readers */
					__( 'Continue reading<span class="screen-reader-text"> "%s"</span>', 'aaa' ),
					array(
						'span' => array(
							'class' => array(),
						),
					)
				),
				wp_kses_post( get_the_title() )
			)
		);

		wp_link_pages(
			array(
				'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'aaa' ),
				'after'  => '</div>',
			)
		);
		?>
	</div><!-- .entry-content -->


</article><!-- #post-<?php the_ID(); ?> -->
